/*
 * Decompiled with CFR 0.152.
 */
package appbot;

import appbot.ABBlocks;
import appbot.ABItems;
import appbot.ABMenus;
import appbot.ae2.MEManaReceiver;
import appbot.ae2.ManaContainerItemStrategy;
import appbot.ae2.ManaHandlerStrategy;
import appbot.ae2.ManaKey;
import appbot.ae2.ManaKeyType;
import appbot.ae2.ManaP2PTunnelPart;
import appbot.client.AppliedBotanicsClient;
import appbot.data.ABDataGenerator;
import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.behaviors.GenericSlotCapacities;
import appeng.api.client.StorageCellModels;
import appeng.api.features.P2PTunnelAttunement;
import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.capabilities.Capabilities;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.common.MEStorageMenu;
import appeng.parts.automation.ForgeExternalStorageStrategy;
import appeng.parts.automation.HandlerStrategy;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.parts.automation.StorageExportStrategy;
import appeng.parts.automation.StorageImportStrategy;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.ISparkAttachable;

@Mod(value="appbot")
public class AppliedBotanics {
    public static final String MOD_ID = "appbot";

    public AppliedBotanics() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ABBlocks.initialize(bus);
        ABItems.initialize(bus);
        ABMenus.initialize(bus);
        bus.addListener(ABDataGenerator::onGatherData);
        bus.addGenericListener(AEKeyType.class, event -> AEKeyTypes.register((AEKeyType)ManaKeyType.TYPE));
        StackWorldBehaviors.registerImportStrategy((AEKeyType)ManaKeyType.TYPE, (level, fromPos, fromSide) -> new StorageImportStrategy(BotaniaForgeCapabilities.MANA_RECEIVER, (HandlerStrategy)ManaHandlerStrategy.INSTANCE, level, fromPos, fromSide));
        StackWorldBehaviors.registerExportStrategy((AEKeyType)ManaKeyType.TYPE, (level, fromPos, fromSide) -> new StorageExportStrategy<IManaReceiver, Object>(BotaniaForgeCapabilities.MANA_RECEIVER, (HandlerStrategy)ManaHandlerStrategy.INSTANCE, level, fromPos, fromSide){});
        StackWorldBehaviors.registerExternalStorageStrategy((AEKeyType)ManaKeyType.TYPE, (level, fromPos, fromSide) -> new ForgeExternalStorageStrategy(BotaniaForgeCapabilities.MANA_RECEIVER, (HandlerStrategy)ManaHandlerStrategy.INSTANCE, level, fromPos, fromSide));
        ContainerItemStrategy.register((AEKeyType)ManaKeyType.TYPE, ManaKey.class, (ContainerItemStrategy)new ManaContainerItemStrategy());
        GenericSlotCapacities.register((AEKeyType)ManaKeyType.TYPE, (Long)((Long)GenericSlotCapacities.getMap().get(AEKeyType.fluids())));
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, this::initializeCapabilities);
        bus.addListener(event -> {
            event.enqueueWork(this::initializeModels);
            event.enqueueWork(this::initializeUpgrades);
            event.enqueueWork(this::initializeAttunement);
        });
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> AppliedBotanicsClient::initialize);
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private void initializeCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        final BlockEntity blockEntity = (BlockEntity)event.getObject();
        event.addCapability(AppliedBotanics.id("generic_inv_wrapper"), new ICapabilityProvider(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
                ManaP2PTunnelPart p2p;
                ISparkAttachable sparkAttachable;
                IPartHost host;
                IPart iPart;
                if (capability == BotaniaForgeCapabilities.SPARK_ATTACHABLE && blockEntity instanceof IPartHost && (iPart = (host = (IPartHost)blockEntity).getPart(side)) instanceof ManaP2PTunnelPart && (sparkAttachable = (p2p = (ManaP2PTunnelPart)iPart).getSparkAttachable()) != null) {
                    return LazyOptional.of(() -> sparkAttachable).cast();
                }
                if (capability == BotaniaForgeCapabilities.MANA_RECEIVER) {
                    return blockEntity.getCapability(Capabilities.GENERIC_INTERNAL_INV, side).lazyMap(inventory -> new MEManaReceiver((GenericInternalInventory)inventory, blockEntity.m_58904_(), blockEntity.m_58899_())).cast();
                }
                if (capability == BotaniaForgeCapabilities.SPARK_ATTACHABLE) {
                    return blockEntity.getCapability(Capabilities.GENERIC_INTERNAL_INV, side).lazyMap(inventory -> new MEManaReceiver((GenericInternalInventory)inventory, blockEntity.m_58904_(), blockEntity.m_58899_())).cast();
                }
                return LazyOptional.empty();
            }
        });
    }

    private void initializeModels() {
        StorageCells.addCellGuiHandler((ICellGuiHandler)new ICellGuiHandler(){

            public boolean isSpecializedFor(ItemStack cell) {
                IBasicCellItem basicCellItem;
                Item item = cell.m_41720_();
                return item instanceof IBasicCellItem && (basicCellItem = (IBasicCellItem)item).getKeyType() == ManaKeyType.TYPE;
            }

            public void openChestGui(Player player, IChestOrDrive chest, ICellHandler cellHandler, ItemStack cell) {
                chest.getUp();
                MenuOpener.open((MenuType)MEStorageMenu.TYPE, (Player)player, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)((BlockEntity)chest)));
            }
        });
        StorageCellModels.registerModel(() -> ABItems.MANA_CELL_CREATIVE.get(), (ResourceLocation)AppEng.makeId((String)"block/drive/cells/creative_cell"));
        for (ABItems.Tier tier : ABItems.Tier.values()) {
            RegistryObject<Item> cell = ABItems.get(tier);
            RegistryObject<Item> portable = ABItems.getPortableCell(tier);
            this.registerCell(() -> cell.get(), () -> portable.get(), cell.getId().m_135815_());
        }
    }

    private void registerCell(ItemLike cell, ItemLike portableCell, String path) {
        StorageCellModels.registerModel((ItemLike)cell, (ResourceLocation)AppliedBotanics.id("block/drive/cells/" + path));
        StorageCellModels.registerModel((ItemLike)portableCell, (ResourceLocation)AppliedBotanics.id("block/drive/cells/" + path));
    }

    private void initializeUpgrades() {
        String storageCellGroup = GuiText.StorageCells.getTranslationKey();
        String portableStorageCellGroup = GuiText.PortableCells.getTranslationKey();
        for (ABItems.Tier tier : ABItems.Tier.values()) {
            RegistryObject<Item> cell = ABItems.get(tier);
            RegistryObject<Item> portableCell = ABItems.getPortableCell(tier);
            Upgrades.add((ItemLike)AEItems.INVERTER_CARD, () -> cell.get(), (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, () -> cell.get(), (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.VOID_CARD, () -> cell.get(), (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.INVERTER_CARD, () -> portableCell.get(), (int)1, (String)portableStorageCellGroup);
            Upgrades.add((ItemLike)AEItems.ENERGY_CARD, () -> portableCell.get(), (int)2, (String)portableStorageCellGroup);
        }
    }

    private void initializeAttunement() {
        P2PTunnelAttunement.registerAttunementTag(() -> ABItems.MANA_P2P_TUNNEL.get());
    }
}

